//The Z6427 sets up an AP with these credentials:
#define STASSID "KeyesWifi_A"
#define STAPSK "KeyesWifi"
//at this server/port
const char* host = "192.168.2.1";
const uint16_t port = 8080;

const char* ssid = STASSID;
const char* password = STAPSK;

#if defined(ESP8266)
//for ESP8266:
#include <ESP8266WiFi.h>
#include <ESP8266WiFiMulti.h>
ESP8266WiFiMulti multi;
#define SOFTRESTART() ESP.restart()
#endif

#if defined(ARDUINO_ARCH_RP2040)
//for Pico:
#include <WiFi.h>
WiFiMulti multi;
#define SOFTRESTART() rp2040.reboot()
#endif

WiFiClient client;

void setup() {
  Serial.begin(115200);
  while(!Serial && millis()<5000){}   //wait for serial with timeout
  Serial.println("Starting");
  multi.addAP(ssid, password);
  if (multi.run() != WL_CONNECTED) {
    Serial.println("Unable to connect to network, rebooting in 10 seconds...");
    delay(10000);
    SOFTRESTART();
  }
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());    
  Serial.println("Type 0 or 1 to set relay.");
}

void loop() {
  int d;
  if(client.connected()){
    if(Serial.available()){
      d=Serial.read();
      if(d=='0'){
        Serial.println("Turning off.");
        client.print("PIN00=1");
      }
      if(d=='1'){
        Serial.println("Turning on.");
        client.print("PIN00=0");
      }
    }
    if(client.available()){
      Serial.print("Received from server:[");
      while(client.available()){
        Serial.write(client.read());
      }
      Serial.println("]");
    }
  }else{
    Serial.println("Trying to connect");
    if (!client.connect(host, port)) {
      Serial.println("Connection failed");
      client.stop();  
      delay(1000);
    }else{
      Serial.println("Connected");    
    }
  }
}
